var browser = browser || chrome;
var mindrenderdomain = "https://mindrender.ai";
var settings = false;
browser.runtime.onInstalled.addListener(() => {
    browser.contextMenus.create({
        id: "update",
        title: "Supported Websites",
        contexts: ["all"]
    });
    browser.alarms.create("checksettings", { periodInMinutes: 1 });
    checksettings();
});
browser.alarms.onAlarm.addListener((alarm) => {
    if (alarm.name === "checksettings") {
        checksettings();
    }
});
browser.contextMenus.onClicked.addListener((info, tab) => {
    if (info.menuItemId === "update") {
        browser.tabs.sendMessage(tab.id, { action: "show_supported" });
    }
});
function loadimg(url, callback) {
    fetch(url)
        .then((response) => {
            if (!response.ok) {
                throw new Error(`Failed to fetch PNG: ${response.statusText}`);
            }
            return response.blob();
        })
        .then((blob) => {
            const reader = new FileReader();
            reader.onloadend = function () {
                callback(reader.result)
            };
            reader.readAsDataURL(blob);
        })
        .catch((error) => {
            console.error("Error downloading PNG:", error);
        });
}
browser.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.action == "get_settings") {
        sendResponse({ "settings": settings });
        return true;
    } else if (message.action == "send") {
        function sendmsg(){
            browser.tabs.query({ url: message.to }, (tabs) => {
                if (tabs.length > 0) {
                    browser.windows.update(tabs[0].windowId, { focused: true });
                    browser.tabs.update(tabs[0].id, { active: true });
                    browser.tabs.sendMessage(tabs[0].id, message).catch((err) => {
                        browser.tabs.reload(tabs[0].id);
                        browser.windows.update(tabs[0].windowId, { focused: true });
                        browser.tabs.update(tabs[0].id, { active: true });
    
                        browser.tabs.onUpdated.addListener(function listener(tabId, changeInfo) {
                            if (tabId === tabs[0].id && changeInfo.status === 'complete') {
                                browser.tabs.onUpdated.removeListener(listener);
                                browser.tabs.sendMessage(tabs[0].id, message);
                            }
                        });
                    });;
                } else {
                    browser.tabs.create({ url: message.to }, (tab) => {
                        browser.tabs.onUpdated.addListener(function listener(tabId, changeInfo) {
                            if (tabId === tab.id && changeInfo.status === 'complete') {
                                browser.tabs.onUpdated.removeListener(listener);
                                browser.tabs.sendMessage(tabId, message);
                            }
                        });
                    });
                }
            });
        }
        if(message.imgurl){
            loadimg(message.imgurl,function(imgdata){
                message.imgdata=imgdata;
                sendmsg();
            })
        }else{
            sendmsg();
        }
        
    } else if (message.action == "update_settings") {
        mr_update_settings(function (data) {
            settings = data;
            sendResponse({ "settings": settings });
            
        })
        return true;
    }

});



function checksettings() {
    if (!settings) {
        mr_get_settings(function (data) {
            settings = data;
        });
    } else if (!settings.update) {
        mr_update_settings(function (data) {
            settings = data;
        });
    } else if (Date.now() - settings.update > 7 * 24 * 60 * 60 * 1000) {
        mr_update_settings(function (data) {
            settings = data;
        });
    }
}
function mr_get_settings(callback) {
    
    mr_get_fetch_json(browser.runtime.getURL('/json/settings.json'), function (data) {
        callback(data);
        console.log("from local");
    })
    
/*
    browser.storage.local.get(['settings'], (result) => {
        if (!result.settings) {
            mr_update_settings(function (data) {
                callback(data);
            })
        } else {
            callback(result.settings);
            console.log("from storage");
        }
    });
*/
}
function mr_update_settings(callback) {
    mr_get_fetch_json(mindrenderdomain + "/public/mr/settings.json", function (data) {
        if (data.err) {
            if (settings) {
                callback(data);
                console.log("from last");
            } else {
                mr_get_fetch_json(browser.runtime.getURL('/json/settings.json'), function (data) {
                    callback(data);
                    console.log("from local");
                })
            }
        } else {
            browser.storage.local.set({ "settings": data }, () => {
                data.update = Date.now();
                callback(data);
                console.log("from mr");
            });
        }
    })
}

function mr_get_fetch_json(url, callback) {
    fetch(url)
        .then((response) => response.json())
        .then((data) => {
            callback(data);
        })
        .catch((error) => {
            console.log(error);
            callback({ "err": true, "info": error });
        });
}